#include "mbed.h"
#include "rtos.h"
#include "ShiftOut.h" // Ollie Milton, https://os.mbed.com/users/ollie8/code/ShiftOut/

DigitalOut buzzer(D3);
Serial pc(USBTX,USBRX);     //UART via ST-Link

typedef uint32_t message_t;
Queue <message_t, 4> queue;

void display_thread(void const *argument)
{
    ShiftOut display(D7, D8, D4);   // clk=D7, data=D8, latch=D4, 16)
    uint8_t segment_data[4] = {0xFF, 0xFF, 0xFF, 0xFF}; // A frissítendő szegmenskép
    /* Számjegyek (0 – 9) szegmensképe, negatív logikával */
    const uint8_t SEGMENT_MAP[]= {0xC0,0xF9,0xA4,0xB0,0x99,0x92,0x82,0xF8,0x80,0x90};
    /* Számjegy (1 - 4) kiválasztó jelek */
    const uint8_t SEGMENT_SELECT[] = {0x01, 0x02, 0x04, 0x08};
    uint8_t i, idx = 0;
    while (true) {
        osEvent evt = queue.get(0);                  // Check for a message without waiting
        switch(evt.status) {
            case osEventMessage:
                printf("osEventMessage = %#05x\n",evt.value.v);  //message arrived
                int n = evt.value.v;
                segment_data[0] = SEGMENT_MAP[(n/1000) %10];
                segment_data[1] = SEGMENT_MAP[(n/100) % 10];
                segment_data[2] = SEGMENT_MAP[(n/10) % 10];
                segment_data[3] = SEGMENT_MAP[n % 10];
                break;
            case osOK:
//---           pc.printf("osOK\n");                            //no error, no message arrived
                i = idx++ & 0x03;
                display.write(segment_data[i]);
                display.write(SEGMENT_SELECT[i]);
                break;
            case osEventTimeout:
                pc.printf("osEventTimeout\n");                  //timeout occurred
                break;
            case osErrorParameter:
                pc.printf("osErrorParameter\n");
                break;                                          //invalid parameter or is out of range.
            default:
                pc.printf("Unknown error flag: %#08x\n",(uint32_t)evt.status);
                break;
        };
        Thread::wait(2);
    }
}

int main (void)
{
    uint16_t raw;
    Thread thread2(display_thread);
    pc.baud(115200);
    buzzer = true;
    while (true) {
        Thread::wait(1000);
        raw++;
        queue.put((message_t*)raw);
    }
}