#include "mbed.h"
#include "rtos.h"
#include "ShiftOut.h" // Ollie Milton, https://os.mbed.com/users/ollie8/code/ShiftOut/
uint8_t segment_data[4] = {0xFF, 0xFF, 0xFF, 0xFF}; // A frissítendő szegmenskép
/* Számjegyek (0 – 9) szegmensképe, negatív logikával */
const uint8_t SEGMENT_MAP[]= {0xC0,0xF9,0xA4,0xB0,0x99,0x92,0x82,0xF8,0x80,0x90};
/* Számjegy (1 - 4) kiválasztó jelek */
const uint8_t SEGMENT_SELECT[] = {0x01, 0x02, 0x04, 0x08};

Thread thread;
DigitalOut buzzer(D3);

void led2_thread()
{
    ShiftOut display(D7, D8, D4);   // clk=D7, data=D8, latch=D4)
    while (true) {
        for(int i = 0; i<4; i++) {
            display.write(segment_data[i]);
            display.write(SEGMENT_SELECT[i]);
            Thread::wait(2);
        }
    }
}

int main()
{
    int n =0;
    buzzer = true;
    thread.start(led2_thread);

    while (true) {
        segment_data[0] = SEGMENT_MAP[(n/1000) %10];
        segment_data[1] = SEGMENT_MAP[(n/100) % 10];
        segment_data[2] = SEGMENT_MAP[(n/10) % 10];
        segment_data[3] = SEGMENT_MAP[n % 10];
        n = n+1;
        buzzer = (n%100) != 0;
        Thread::wait(250);
    }
}