/*
 *  OLED I2C display demo based on the Adafruit_GFX
 *  library forked from Neal Horman
 *  Link: https://os.mbed.com/users/nkhorman/code/Adafruit_GFX/ 
 *  The library was modified and extended so that it could be used
 *  also for 128x64 I2C OLED displays driven by SH1106 controller.
 *  See the documentation page for Adafruit_SH1106_I2c
 */

#include "mbed.h"
#include "Adafruit_SSD1306.h"

I2C i2c(D14,D15);
Adafruit_SH1106_I2c oled(i2c, NC, 0x78, 64, 128);     // SH1106  I2C 128x64, with no reset pin
// Adafruit_SSD1306_I2c oled(i2c, NC, 0x78, 64, 128); // SSD1306 I2C 128x64, with no reset pin
// Adafruit_SSD1306_I2c oled(i2c, NC, 0x78, 32, 128); // SSD1306 I2C 128x32, with no reset pin

int main()
{
    uint16_t x=0;
    i2c.frequency(400000);
    oled.setRotation(0);
    oled.clearDisplay();
    oled.drawRect(0,0,oled.width(),oled.height(),1); 
    oled.display();
    oled.setTextColor(WHITE);
    oled.setTextSize(1);
    oled.setTextCursor(10,8);
    oled.printf("SH1106 %ux%u",oled.width(),oled.height());
    oled.display();
    wait(2.0);
    oled.setTextSize(2);
    while(1) {
        oled.clearDisplay();
        oled.drawRect(0,0,oled.width(),oled.height(),1);
        oled.setTextCursor(10,8);
        oled.printf("x = %u",x++);
        oled.display();
        wait(1.0);
    }
}