#include "mbed.h"
#include "Adafruit_SSD1306.h"

I2C i2c(D14,D15);
Adafruit_SH1106_I2c oled(i2c, NC, 0x78, 64, 128);     // SH1106  I2C 128x64, with no reset pin
Serial pc(USBTX,USBRX);     //UART0 via OpenSDA
DigitalOut myled(LED1);
Ticker myticker;
static char msg[20];        // character buffer
volatile uint8_t myflag = 0;
#define DATE_20200222_222222    1582377742      // 2020/2/22 22:22:22 

void processSerialCommand();

void setflag(void)
{
    myflag = 1;
}

int main()
{
    pc.baud(115200);
    time_t seconds;
    seconds = time(NULL);
    if (seconds < DATE_20200222_222222) {
        set_time(DATE_20200222_222222);
    }
    i2c.frequency(400000);
    oled.setRotation(0);
    oled.clearDisplay();
    oled.setTextColor(1);
    oled.setTextSize(1);
    oled.setTextCursor(10,8);
    oled.display();
    myticker.attach(&setflag,1);
    while(1) {
        if(pc.readable()) {
            processSerialCommand();
        }
        if(myflag) {
            seconds = time(NULL);
            oled.clearDisplay();
            oled.setTextSize(1);
            oled.setTextCursor(14,1);
            strftime (msg, 15, "%Y-%b-%d %a ", localtime(&seconds));  // Display date
            oled.printf("%s",msg);
            strftime (msg, 10, "%T ", localtime(&seconds));           // Display time
            oled.setTextSize(2);
            oled.setTextCursor(10,12);
            oled.printf("%s",msg);
            oled.display();
            pc.printf("RTC time: %s\r\n",ctime(&seconds));
            myflag = 0;
        }
    }
}

void processSerialCommand()
{
    char c = pc.getc();
    switch(c) {
        case 'T':
            // Command to set RTC time
            // Command format: TYYMMDDHHMMSS
            // Example: 2012 Oct 21 1:23pm is T121021132300
            struct tm tme;
            time_t newTime;

            // Parse incomming 12 ASCII charaters into time_t
            // no error checking for numeric values in YYMDDHHMMSS fields, so be careful!
            c = pc.getc();
            tme.tm_year = c - '0';
            c = pc.getc();
            tme.tm_year = 10*tme.tm_year;
            tme.tm_year += c-'0';
            tme.tm_year += 100;             //Years are counted from 1900!
            c = pc.getc();
            tme.tm_mon = c - '0';
            c = pc.getc();
            tme.tm_mon = 10*tme.tm_mon;
            tme.tm_mon += c-'0'-1;          //corrected by -1 due to a stupid error
            c = pc.getc();
            tme.tm_mday = c - '0';
            c = pc.getc();
            tme.tm_mday = 10*tme.tm_mday;
            tme.tm_mday += c-'0';
            c = pc.getc();
            tme.tm_hour = c - '0';
            c = pc.getc();
            tme.tm_hour = 10*tme.tm_hour;
            tme.tm_hour += c-'0';
            c = pc.getc();
            tme.tm_min = c - '0';
            c = pc.getc();
            tme.tm_min = 10*tme.tm_min;
            tme.tm_min += c-'0';
            c = pc.getc();
            tme.tm_sec = c - '0';
            c = pc.getc();
            tme.tm_sec = 10*tme.tm_sec;
            tme.tm_sec += c-'0';
            newTime = mktime(&tme);
            set_time(newTime);
            pc.printf("RTC set to: %s\r\n",ctime(&newTime));
    }
    while(pc.readable()) {
        pc.getc();    // clear serial buffer
    }
}
