#include "mbed.h"
#include "BME280.h"
#include "Adafruit_SSD1306.h"
#include "Adafruit_SSD1306.h"

I2C i2c(D14,D15);

BME280 sensor(i2c, 0x76<<1);
Adafruit_SH1106_I2c oled(i2c, NC, 0x78, 64, 128);     // SH1106  I2C 128x64, with no reset pin
// Adafruit_SSD1306_I2c oled(i2c, NC, 0x78, 64, 128); // SSD1306 I2C 128x64, with no reset pin
// Adafruit_SSD1306_I2c oled(i2c, NC, 0x78, 32, 128); // SSD1306 I2C 128x32, with no reset pin

int main()
{
    char fok = 9;
    i2c.frequency(400000);
    oled.setRotation(0);
    oled.clearDisplay();
    oled.setTextColor(WHITE);
    oled.setTextSize(2);
    oled.setTextCursor(10,8);
    oled.printf("BME280 \r\n  demo");
    oled.display();
    wait(5.0);
    while(1) {
        float tempC = sensor.getTemperature();
        float pressure = sensor.getPressure();
        float humidity = sensor.getHumidity();
        oled.clearDisplay();
        oled.setTextCursor(20,4);
        oled.printf("%.1f %cC",tempC,fok);
        oled.setTextCursor(8,24);
        oled.printf("%.1f hPa",pressure/0.985);
        oled.setTextCursor(20,44);
        oled.printf("%.0f %%",humidity);
        oled.display();
        wait(2);
    }
}