#include "mbed.h"
#include "BufferedSerial.h"

BufferedSerial pc(USBTX,USBRX);
BufferedSerial xbee(PA_0, PA_1);

char fb[1024];

int main()
{
    pc.baud(115200);
    xbee.baud(38400);
    int i = 0;
    pc.printf("\r\nXbee COORDINATOR1 received:\r\n");
    while(1) {
        while(xbee.readable()) {
            fb[i++] = xbee.getc();
        }
        if(i<20) {
            wait(0.5);
        } else {
            for(int c=0; c<i; c++) {
                pc.printf("%02x ",fb[c]);
            }
            pc.printf("\r\n");
            i = 0;
        }
    }
}
