#include "mbed.h"
#include "bitmap.h"

#define NOP                 0x00
#define Function_Set        0x20
#define Display_Control     0x08
#define Set_Y_Address       0x40
#define Set_X_Address       0x80
#define Set_V0              0x80
#define Set_Test_Mode       0x30

DigitalOut SCK_pin(D13);   // SPI clock
DigitalOut SDI_pin(D11);   // SPI MOSI
DigitalOut DC_pin(D10);    // Data/command selector
DigitalOut RST_pin(D9);    // HW Reset
DigitalOut CS_pin(D8);     // SPI chip select


void LCDShiftWrite(unsigned char dat)
{
    unsigned char i;
    unsigned char Series,Temp;
    SCK_pin = false;
    Series = dat;
    for(i=0; i<8; i++) {
        SCK_pin = false;
        Temp=Series & 0x80;
        if(Temp) {
            SDI_pin = true;
        } else {
            SDI_pin = false;
        }
        SCK_pin = true;
        Series = Series << 1;
    }
}


void send_cmd(unsigned char cmd, unsigned char dat)
{
    DC_pin = false; //digitalWrite(RSX,LOW);
    CS_pin = false; //digitalWrite(CSX,LOW);
    LCDShiftWrite(cmd|dat);
    CS_pin = true;  //digitalWrite(CSX,HIGH);
    DC_pin = true;  //digitalWrite(RSX,HIGH);
}

void send_dat(unsigned char dat)
{
    DC_pin = true;  //digitalWrite(RSX,HIGH);
    CS_pin = false; //digitalWrite(CSX,LOW);
    LCDShiftWrite(dat);
    CS_pin = true;  //digitalWrite(CSX,HIGH);
}


void LCDInit()
{
    RST_pin = false; //digitalWrite(RESX,LOW);
    wait_ms(10);
    RST_pin = true;  //digitalWrite(RESX,HIGH);
    wait_ms(100);
    send_cmd(Function_Set,0x01);
    send_cmd(Set_V0,0x20);
    send_cmd(Set_Test_Mode,0x02);
    send_cmd(Function_Set,0x00);
    send_cmd(Display_Control,0x04);
}

void LCD_set_XY(unsigned char x,unsigned char y)
{
    send_cmd(Set_X_Address,x);
    send_cmd(Set_Y_Address,y);
}

void cls(void)
{
    int i;
    send_cmd(Set_X_Address,0);
    send_cmd(Set_Y_Address,0);
    for(i=0; i<960; i++)
        send_dat(0x00);
    send_cmd(Set_X_Address,0);
    send_cmd(Set_Y_Address,0);
}

void putch(unsigned char x, unsigned char y, unsigned int ch)
{
    unsigned char i;
    send_cmd(Set_X_Address,x);
    send_cmd(Set_Y_Address,y);
    for(i=0; i<5; i++)
        send_dat(FONT[(ch-0x20)*5+i]);
}

void putstr(unsigned char x, unsigned char y, char *str)
{
    while(*str!=0) {
        putch(x,y,*str++);
        x=x+6;
    }
}

void SHOW_BMP()
{
    unsigned int i,j,n=0;
    for(i=0; i<8; i++) {
        for(j=0; j<96; j++) {
            send_cmd(Set_Y_Address,7-i);
            send_cmd(Set_X_Address,j);
            send_dat(BMP[n++]);
        }
    }
}

void SHOW_ICO()
{
    unsigned char i;
    for(i=0; i<96; i++) {
        send_cmd(Set_Y_Address,8);
        send_cmd(Set_X_Address,i);
        send_dat(0xFF);
    }
}

void SHOW_LINE()
{
    unsigned int i,j;
    const unsigned char line[8] = {
        0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80
    };
    for(i=0; i<8; i++) {
        send_cmd(Set_Y_Address,7-i);
        for(j=0; j<8; j++) {
            send_cmd(Set_X_Address,j+8*i);
            send_dat(line[j]);
        }
    }
}

int main()
{

    LCDInit();


    while(1) {
        SHOW_ICO();
        putstr(30,5,"ST7585");
        putstr(15,3,"96*64 GLCD");
        putstr(10,1,"ARM Mbed demo");
        wait_ms(5000);
        cls();
        SHOW_LINE();
        wait_ms(5000);
        cls();

        SHOW_BMP();
        wait_ms(5000);
        cls();
    }
}

