#include "mbed.h"
I2C i2c(D14, D15);                // Arduino compatible I2C pins
const int addr = 0xD0;            // Left aligned DS3231 address: 0x68<<1

int main()
{
    char cmd[20];                 // data buffer
    printf("\r\nDS3231 I2C RTC readout demo\r\n");
    cmd[0] = 0x0E;                // Pointer to CONFIG register
    cmd[1] = 0x00;                // Data for CONFIG (enable clock)
    i2c.write(addr, cmd, 2);      // Send Address/command and two bytes
    while (1) {
        wait(1);
        cmd[0] = 0x00;            // Pointer to first register
        i2c.write(addr, cmd, 1);  // Write adress/command byte, then register address
        i2c.read(addr, cmd, 19);  // Read 19 bytes from the DS3231 chip
        for(int i=0; i<19; i++) {
            printf("%02x ",cmd[i]);
        }
        printf("\r\n");
    }
}