#include "mbed.h"
Serial pc(USBTX,USBRX); 
DigitalOut myled(LED1);             //define LED
DigitalIn mybutton(BUTTON1,PullUp); //define pushbutton input with pull-up
Timer t;                            //define timer
int x;                              //x for random number storage

int main() {
    pc.baud(115200);
    myled = 0;                      //LED is initially off 
    pc.printf("\r\nReaction test!\r\n");
    pc.printf("Push the button when the LED is on!\r\n");
    while(1) {
        t.reset();                  //reset the timer        
        while(!mybutton);           //wait for button release
        x=rand()%2000;              //generate random number 0-2000
        wait_ms(1000+x);            //wait random time between 1 and 3 seconds
        t.start();                  //start the timer
        myled=1;                    //LED on
        while(mybutton);            //wait for press
        t.stop();                   //stop the timer
        myled=0;                    //LED off
        wait_ms(20);                //debounce delay
        printf("The time taken was %f seconds\r\n", t.read());
    }
}