#include "mbed.h"

DigitalIn button(BUTTON1,PullUp);       // Pusbutton input
DigitalOut led(LED1);                   // Builtin LED
Ticker sampler;                         // Ticker for button state sampling
volatile uint8_t button_state = 1;      // Initially released

void button_check()
{
    button_state = (button_state<<1) | (button & 1); // shift in button state
    if((button_state & 3)==2) {         // Check for H -> L transition
        led = !led;                     // Switch LED state
    }
}

int main()
{
    led = 0;                            // LED off
    sampler.attach(&button_check,0.02); // sample button state in each 20 ms
    while (true) {
        wait(1);                        // do nothing
    }
}