#include "mbed.h"

DigitalIn mybutton(BUTTON1,PullUp); // Pushbutton input (PC_13)
InterruptIn button(BUTTON1);        // Pusbutton interrupt
Serial pc(USBTX,USBRX);             // UART0 via OpenSDA
volatile uint16_t counts;           // counter variable

void button_pressed() {
    counts++;                       // counts button presses
}

int main() {
    pc.baud(115200);                // set baudrate for UART
    button.mode(PullUp);            // Enable internal pullup
    button.fall(&button_pressed);   // Attach function to falling edge
    while (true) {
        counts = 0;                 // Clear counter
        pc.printf("Press & release switch... \r\n");
        while (mybutton);           // Wait for button press
        wait_ms(20);                // Debounce delay
        while (!mybutton);          // Wait for button release
        wait_ms(20);                // Debounce delay
        pc.printf("Button pressed %d times\r\n",counts);
    }
}