#include "mbed.h"

InterruptIn b_on(PC_10);       // Pusbutton input (PC_10)
InterruptIn b_off(PC_12);      // Pusbutton input (PC_12)
DigitalOut led(LED1);          // LED output (PA_5)

void b_on_pressed() {
    led = 1;                   // LED on
}

void b_off_pressed() {
    led = 0;                   // LED off
}

int main() {
    b_on.mode(PullUp);         // Enable internal pullup
    b_on.fall(&b_on_pressed);  // Attach function to falling edge
    b_off.mode(PullUp);        // Enable internal pullup
    b_off.fall(&b_off_pressed); // Attach function to falling edge
    while (true) {
        wait(0.2f);            // Nothing to do. Just wait
    }
}