/* Demonstrates Timeout, by triggering an event
 * a fixed duration after a button press.
 */
#include "mbed.h"
Timeout wecker;          //create a Timeout, and name it "Response"
DigitalIn button(BUTTON1);
DigitalOut led(LED1);    //blinks with main while(1) loop
volatile int state = 0;

void noblink()           //this function is called at the end of the Timeout
{
    state = 0;           // Stop blinking
}

int main() {
    while(1) {
        if(button==0) {
            wecker.attach(&noblink,2.0); //attach noblink function to Response
                                         //Timeout, to occur after 2 seconds
            state = 1;                   // Start binking LED
        }
        if(state) {
            led=!led;
            wait(0.2);
        } else {
            led = 0;
        }
    }
}
