#include "mbed.h"
/* Lab03_ adc_scan
 *
 * Pásztázó mérés az ADC-vel: több csatornát pásztázunk
 * - az A0 bemeneten egy potméterrel leosztott feszültséget mérünk
 * - az A1 bemeneten egy MCP9700 analóg hőmérő jelét mérjük
 * - az A2 bemeneten egy LDR segítségével a fényt mérjük
 * - az A3 bemeneten pedig egy 2,50 V-os referencia feszültséget mérünk
 * Az eredményeket feszültségre átszámítva a soros porton kiíratjuk.
 */
const float VREFH = 3.3;    // VrefH referencia feszültség [V]
int data[4] = {0, 0, 0, 0}; // A mérési adatok tárolója
float v[4];                 // Feszültség mV-okban
AnalogIn potm(A0);          // Analog input at PA_0
AnalogIn homero(A1);        // Analog input at PA_1
AnalogIn ldr(A2);           // Analog input at PA_4
AnalogIn vref(A3);          // Analog input at PB_0

int main()
{
    printf(" Lab03_adc_scan: Pásztázó mérés ADC-vel\r\n");
    printf(" - az A0 bemeneten egy potméterrel leosztott feszültségét mérjük\r\n");
    printf(" - az A1 bemeneten egy MCP9700 analóg hőmérő jelét mérjük\r\n");
    printf(" - az A2 bemeneten egy LDR segítségével a fényt mérjük\r\n");
    printf(" - az A3 bemeneten pedig egy referencia feszültséget mérünk\r\n");
    while(1) {
        for(int i=0; i<4; i++) data[i]=0;
        for(int i=0; i<1000; i++) {
            data[0] += potm.read_u16();
            data[1] += homero.read_u16();
            data[2] += ldr.read_u16();
            data[3] += vref.read_u16();
        }
        for(int i=0; i<4; i++) {
            v[i] = VREFH*(data[i]>>16);        // V = NADC * VREFH / 2^16
            printf(" A%d = %5.0f mV\r\n",i,v[i]);
        }
        printf("----------------------------------\r\n");
        wait(2);
    }
}