#include "mbed.h"

AnalogIn cds(A0);                           // Analog input at PA0
DigitalOut led(D10);                        // Led contolled by D10

uint32_t measLight(int nmeas)
{
    uint32_t sum0, sum1, diff;
    led = 0;
    sum0 = 0;
    for (int i = 0; i < nmeas; i++) {
        sum0 += cds.read_u16();
    }
    led = 1;
    sum1 = 0;
    for (int i = 0; i < nmeas; i++) {
        sum1 += cds.read_u16();
    }
    if (sum0 > sum1) {
        diff= 0;
    } else {
        diff = (sum1 - sum0) / nmeas;
    }
    printf("L1: %5d  L0: %5d  Diff: %5d\r\n",sum1/nmeas, sum0/nmeas, diff);
    return diff;
}

int main()
{
    printf("\r\n Lab03_light_sensor - with averaging\r\n");
    while(1) {
        measLight(1000);
        wait(2);
    }
}