#include "mbed.h"

PwmOut myled(LED1);         // PA_5, a beépített LED
Serial pc(USBTX, USBRX);    // tx, rx aoros terminál a PC-hez

int main() {
    pc.baud(115200);        // Adatsebesség beállítása
    myled.period_ms(20);    // Periódus = 20 ms
    myled.write(1.0);       // LED kezdetben kikapcsolva
    
    while(1) {
        char c = pc.getc(); // Beolvasunk egy karaktert
        if(c=='1') {
            myled = 0.01f;  // LED 1 % kitöltéssel
            pc.printf("Duty cycle = 0.01\r\n");
        }
        else if(c=='5') {   // LED 50 % kitöltéssel
            myled = 0.5f;
            pc.printf("Duty cycle = 0.5\r\n");        
        }
        else if(c=='9') {
            myled = 0.99f;   //LED 99 % kitöltéssel
            pc.printf("Duty cycle = 0.99\r\n");            
        }        
        wait(0.2);
    }
}