#include "mbed.h"
#include "USBAudio.h"
#include "I2S.h"

Serial pc(USBTX, USBRX);

// frequency: 48 kHz
#define FREQ 48000

// 1 channel: mono
#define NB_CHA 2

// length of an audio packet: each ms, we receive 48 * 16bits ->48 * 2 bytes per channel. For stereo multiply by 2 
#define AUDIO_LENGTH_PACKET 48 * 2 * 2

// USBAudio
USBAudio audio(FREQ, NB_CHA,FREQ, NB_CHA,0x7bb8, 0x1112);

int main() {
    int16_t buf[AUDIO_LENGTH_PACKET/2];
    
    
    setup(&pc);
    
    while (1) {
        // read an audio packet
        audio.read((uint8_t *)buf);

        // send to DAC
        play(buf,AUDIO_LENGTH_PACKET/2);
    }
}
