#include "mbed.h"
#include "HEPTA_EPS.h"
#include "HEPTA_SENSOR.h"
#include "HEPTA_CDH.h"

HEPTA_CDH cdh(p5, p6, p7, p8, "sd");
 
Serial pc(USBTX, USBRX, 9600);
HEPTA_EPS eps(p16,p26);
HEPTA_SENSOR sensor(p17,
                  p28,p27,0x19,0x69,0x13,
                  p13, p14,p25,p24);

AnalogIn mic(p15); //microphone input

DigitalOut led1(LED1); // following leds are used to visualy show amplitude of sound
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Timer sattime;

void record(float* sampleArr) {
    //record sound for 1 second
    for(int i=0; i<4000; i++) {
        sampleArr[i] = mic.read(); //put samples in array
        wait(0.000125f); //sample rate of 8000 Hz
    }  
}

void volume(){
    //the following lights up the onboard LEDs depending on the amplitude of sound
    led1 = (mic > 0.5f) ? 1 : 0;
    led2 = (mic > 0.6f) ? 1 : 0;
    led3 = (mic > 0.7f) ? 1 : 0;
    led4 = (mic > 0.8f) ? 1 : 0;
}

int rcmd=1;

int main() {
    float sampleArr[4000];
    sattime.start();
    float starttime=sattime.read();
    pc.printf("Start time: %f\r\n",starttime);
    pc.baud(9600);
    while(1){
        volume();
        if(rcmd == 1) {
            record(sampleArr);
            float endtime=sattime.read();
            pc.printf("The following data has been written:\r\n");
            for (int j=0; j<400; j++) {
                if (j == 0){
                pc.printf("%f = %f\r\n",starttime,sampleArr[j]);
                }
                else {
                pc.printf("%f = %f\r\n",endtime,sampleArr[j]);
                }
             }
            FILE *fp = fopen("/sd/mydir/test2.txt","w");  
            if(fp == NULL) {
                error("Could not open file for write\r\n");
            }
            for (int j=0; j<400; j++) {
                fprintf(fp,"%f\r\n",sampleArr[j]);
            }
            fclose(fp);
            wait(5);
            pc.printf("Writing data complete\r\n");
        }
    }
}