
#pragma once
#include <mbed.h>

/**
 * K64F RGB LED example:
 * KRGBLed rgb(LED_RED, LED_GREEN, LED_BLUE);
 * rgb.set(KRGBLed::Magenta);
 */
class KRGBLed
{
public:
    typedef enum
    {
        Off = 0,
        Red = 1,
        Green = 2,
        Blue = 4,
        Yellow = (Red|Green),
        Cyan = (Green|Blue),  // @note more like a whiteish-blue
        Magenta = (Blue|Red),
        White = (Red|Green|Blue),
    } Color;

    KRGBLed(PinName redPin, PinName greenPin, PinName bluePin);
    ~KRGBLed();

    void set(Color color);

private:
    DigitalOut red;
    DigitalOut green;
    DigitalOut blue;
};