//Joystick (INCOMPLETE IMPLIMENTATION)
//Author: Carter Sharer 
//Date: 10/18/16

#include "Joystick.h"
#include "mbed.h"

//Member function definitions including constructor
Joystick::Joystick(PinName pinA, PinName pinB) : horiz(pinA), vert(pinB) {
    //Wait 1 second for voltage to settle
    wait(1); 
    
    //(1)Set Raw Center Values, this is where the joystick sits naturaly 
    //set raw horizontal center to current value (average with 5 readings)
    //set raw vertial center to current value (average with 5 readings) 
    raw_hc = 0;
    raw_vc = 0; 
    
    //(2)Initalize the Rax Max to some value less then the real max value.  
    //We dont know what the max value will be until we read it, thats ok. 
    //But we can assume it will be greater then 0.8 (center + 0.3) so lets 
    //set it to that for now.  We will update this later if we see a larger value
    //Now do the same for the the Raw Min
    float delta = 0.3;
    rawMinH = 0;
    rawMaxH = 0;
    rawMinV = 0;
    rawMaxV = 0;
}

//Returns the scaled vertial value of joystick
float Joystick::horizontal(void) {
    //(3)Get average val (5 samples)
    float avg = horiz.read();
    
    //(4)Watch for Max and Min Values, if we see a new max/min update Raw Max/Min
    rawMaxH = avg;    
    rawMinH = avg;
    
    //(5)Here we will calculate the total range (Travel) of the joystick 
    //using the rawMax/rawMin values we have seen thus far
    //Since the joystick is not symetrical we have to calculate two ranges
    //Calculate the range from [center, max] and [center, min]
    float range_pos = 0;
    float range_neg = 0;
    
    //(6)Here we will calculate how much our current reading is in one 
    //of the ranges, this will give us a percentage of our _max value we 
    //set in setScale. Then we can apply the scale by multiplying it by our 
    //scale (_max/_min). 
    float val;
    if(avg >= raw_hc) //Positive Range
        val = 0; 
    else  //Negative Range
        val = 0; 
         
    //(7)Here we will apply a dead zone.  If the |value| is <= our deadzone then 
    //set it to 0.  Otherwise we need to shift the value closer to 0 by dead zone
    
    
    return horiz.read();
}

//(8) Impliment vertial the same as you did for horizontal
//Returns the scaled horizontal value of joystick
float Joystick::vertical(void) {
    //Get average value (5 samples)
    float avg = vert.read();
    
    //(4)Watch for Max and Min Values, if we see a new max/min update Raw Max/Min
    rawMaxV = avg;
    rawMinV = avg;
    
    //(5)Here we will calculate the total range (Travel) of the joystick 
    //using the rawMax/rawMin values we have seen thus far
    //Since the joystick is not symetrical we have to calculate two ranges
    //Calculate the range from [center, max] and [center, min]
    float range_pos = 0;
    float range_neg = 0;
    
    //(6)Here we will calculate how much our current reading is in one 
    //of the ranges, this will give us a percentage of our _max value we 
    //set in setScale. Then we can apply the scale by multiplying it by our 
    //scale (_max/_min).
    float val;
    if(avg >= raw_vc) //find scaled pot value
        val = 0;
    else 
        val = 0;
    
    //(7)Here we will apply a dead zone.  If the |value| is <= our deadzone then 
    //set it to 0.  Otherwise we need to shift the value closer to 0 by dead zone    
    
    return vert.read();
}

//Set the Min and Max Values of joystick ex: -100, +100
void Joystick::setScale(float min, float max) {
       _min = min-1; //Add 1 for round off error
       _max = max+1; //Add 1 for round off error
}