#include "mbed.h"
#include "rtos.h"
#include <algorithm>

using namespace std;

DigitalOut latch(p9);
DigitalOut enable(p10);
 
SPI spi(p11, p12, p13);

DigitalOut valve1(p15);
DigitalOut valve2(p16);
DigitalOut valve3(p17);

AnalogIn distSensor(p20);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

Serial pc(USBTX, USBRX);
//uLCD_4DGL lcd(p28, p27, p30);

int vTime[3];
bool t_enabled;
osThreadId mainThreadID;

void RGB_LED(int red, int green, int blue) {
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}

void thread1(void const *args)
{
    while (1)
    {
        if (t_enabled)
        {
            valve1 = 1; led1 = 1;
            int waitTime = (int)(vTime[0] * 100);
            Thread::wait(waitTime);
            valve1 = 0; led1 = 0;
            t_enabled = false;
            osSignalSet(mainThreadID, 0x1);
        }
    }
}

void thread2(void const *args)
{
    while (1)
    {
        if (t_enabled)
        {
            valve2 = 1; led2 = 1;
            int waitTime = (int)(vTime[1] * 100);
            Thread::wait(waitTime);
            valve2 = 0; led2 = 0;
            t_enabled = false;
            osSignalSet(mainThreadID, 0x2);
        }
    }
}

void thread3(void const *args)
{
    while (1)
    {
        if (t_enabled)
        {
            valve3 = 1; led3 = 1;
            int waitTime = (int)(vTime[2] * 100);
            Thread::wait(waitTime);
            valve3 = 0; led3 = 0;
            t_enabled = false;
            osSignalSet(mainThreadID, 0x4);
        }
    }
}

void thread4(void const *args)
{
    int red=0;
    int green=0;
    int blue=0;
    while(1) {
        for (red = 0; red<1000; red = red+200) {
            for (blue = 0; blue<1000; blue = blue+200) {
                for (green = 0; green<1000; green = green+200)
     
                {
                    RGB_LED( red, green, blue);
                    Thread::wait(250);
                }
            }
        }
    }
}

void thread5(void const * args)
{
    Thread::wait(15000);
    while (1)
    {      
        //bool flag = false;
        //pc.printf("%f\n", distSensor);
        if (distSensor > 0.05)
        {
            pc.putc('l');
            //pc.putc(' ');    
             //wait(0.5);
            //Thread::wait(12000000);
            break;
        }
        //Thread::wait(500);
    }
}

int main()
{
    mainThreadID = osThreadGetId();
    Thread t1(thread1);
    Thread t2(thread2);
    Thread t3(thread3);
    Thread t4(thread4);
    //Thread t5(thread5);
    t_enabled = false;
    char message;
    char msg[10];
    char m[4];
    

    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;
    wait(10);
    while(distSensor < 0.05) {}
    pc.putc('l');

    int i;
    while (1)
    {
        if (pc.readable())
        {
            message = pc.getc();
            if (message == 'g')
            {
                i = 0;
                while (i < 10)
                {
                    if (pc.readable())
                    {
                        msg[i] = pc.getc();
                        i++;
                    }
                }
                sprintf(m, "%.4s", msg);
                vTime[0] = atoi(m);
                //lcd.printf("%d\n", vTime[0]);
                //lcd.printf("%s\n", m);

                sprintf(m, "%.3s", msg + 4);
                vTime[1] = atoi(m);

                //lcd.printf("%d\n", vTime[1]);
                //lcd.printf("%s\n", m);
                sprintf(m, "%.3s", msg + 7);
                vTime[2] = atoi(m);

                //lcd.printf("%d\n", vTime[2]);
                //lcd.printf("%s\n", m);
                t_enabled = true;
                osSignalWait(0x7, osWaitForever);
                pc.putc('j');
            }
            if (message == 'a')
            {
                valve1 = 1; led1 = 1;
            }
            if (message == 'b')
            {
                valve1 = 0; led1 = 0;
            }
            if (message == 'c')
            {
                valve2 = 1; led2 = 1;
            }
            if (message == 'd')
            {
                valve2 = 0; led2 = 0;
            }
            if (message == 'e')
            {
                valve3 = 1; led3 = 1;
            }
            if (message == 'f')
            {
                valve3 = 0; led3 = 0;
            }
        }
    }
}
