#ifndef PLAYER_H
#define PLAYER_H
#include "vs10xx.h"

/** Playing states definations. */
volatile typedef enum {
  PS_STOP,	       // Player stop						 
  PS_PLAY,         // Start to player                                                                    
} playerStatetype;

/** Control states definations. */
volatile typedef enum
{
  CS_EMPTY = 0,      // Have no control                                     
  CS_PLAYPAUSE,      // Play/pause button pressed                     
  CS_RECORDING,      // Play/pause button long pressed               
  CS_UP,             // Up button pressed                                                          
  CS_DOWN,           // Down button pressed                                                       
  CS_NEXT,           // Right button pressed                                                      
  CS_PREV,           // Left button pressed                                                       
} ctrlStatetype;

class Player
{
public:
  void begin(void);
  void playFile(char *file);
  void stop(void);
private:
    
};

#endif

