/**
xAP enabed one wire master Part II
Author: Zhongying Qiao
Date: 9th March 2014
Tested working 3rd March 2014 Qiao

**/


//one wire communication
#include "mbed.h"
#include "rtos.h"
#include "OneWire.h"
#include "Network.h"
#include "DS1920.h"
#include "demo_for_temperature.h"
//xAP
#include "EthernetInterface.h"
//webpage
#include "Websocket.h"
//email SMTP client
#include "NTPClient.h"
#include "SimpleSMTPClient.h"

#define DOMAIN "DOMAIN"// no impact
#define SERVER "aspmx.l.google.com" 
#define PORT "25" // Port 25 doesn't require TSL
#define USER "me"//doesn't matter
#define PWD "does_not_matter"//doesn't matter
#define FROM_ADDRESS "mbed"// doesn't matter


// less than 128 characters.
#define TO_ADDRESS "anywhere@gmail.com" // must be an gmail address

#define SUBJECT "temperature warning message"



int main() {
    char recv[30];  //webpage data
    char strTimeMsg[16];// time of LCD
    char msg[]="Hello this is a message from mbed ";//email content
    const int BROADCAST_PORT=3639 ;//designated port for xAP sending UDP packets
    puts("program started\r");
    
    printf("Setting up Ethernet...\n");
    EthernetInterface eth;
    eth.init();//use DHCP
    //printf("result from init %d\r\n",eth.init("172.20.177.241 ", "255.255.255.0", "172.20.177.1"));
    //printf("IP Address is %s\r\n", eth.getIPAddress());
    //printf("gateway is %s\r\n", eth.getGateway());
    //printf("mask is %s\r\n", eth.getNetworkMask());
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    //UDP packet broadcast setup
    UDPSocket udp;
    udp.init();
    printf("broadcasting success? %d \n", udp.set_broadcasting(true));
    Endpoint broadcast;
    printf("set address result %d\n",  broadcast.set_address("255.255.255.255", BROADCAST_PORT));
    
    //setting up SMTP client
    SimpleSMTPClient smtp;
    int ret;
    smtp.setFromAddress(FROM_ADDRESS);
    smtp.setToAddress(TO_ADDRESS);
    
    //xAP message upon Ethernet connection
    char *packet_a = "xap-header\n"
                 "{\n"
                         "v=12\n"
                         "hop=1\n"
                         "uid=FF101200\n"
                         "class=SMS.Message\n"
                         "source=georg.mbedlpc1768.ibutton7E\n"
                 "}\n"
                 "Outbound\n"
                 "{\n"
                    "msg=(This is an xAP message from mbed, Ethernet connected!)\n"
                    "num=(00447401696842)\n"   
                 "}\n";
    
        printf("Broadcasting...\n");
        printf( "bytes sent= %d\n",udp.sendTo(broadcast, packet_a, strlen(packet_a)));
        

while(true){
      
      
    reset_thread();// calling one_wire demo for returning temperature measurement and device ID
    
    
    
    sprintf(msg, "IButton thermometor ID %llX , temperature measured at %f \n",rom, temperature);  
    
    smtp.setMessage(SUBJECT,msg);
    smtp.addMessage(" It's exceeding previously set temperature threshold!! \r\n");
    
    while(temperature> 10.0) {    
                            printf("temperature alart\n");
                            ret = smtp.sendmail(SERVER, USER, PWD, DOMAIN,PORT,SMTP_AUTH_NONE);
 
                                if (ret) {
                                    printf("E-mail Transmission Error\r\n");
                                         } 
                                else {
                                    printf("E-mail Transmission OK\r\n");
                                     }
                            wait(1.0);
                            break;
                            }
    
    Websocket ws("ws://sockets.mbed.org:443/ws/georg/rw");//"ws://sockets.mbed.org/ws/georg/rw" to view the dynamic reading
    ws.connect();
    
    sprintf(recv, "Temperature of device %llX is %f: \n",rom, temperature); 
    ws.send(recv);
    temperature =0;
    wait(2.0);
    }
    
    
    
} 
