/** xAP enabled one wire master part I
Author: Zhongying Qiao
Date: 10th March 2014

Updated@24th July 2015

**/

//one wire communication
#include "mbed.h"
#include "rtos.h"
#include "OneWire.h"
#include "Network.h"
#include "DS1920.h"
#include "demo_for_temperature.h"
//xAP
#include "EthernetInterface.h"
//webpage
#include "Websocket.h"



int main() {
    char recv[30];   
    
    puts("program started\r");
    
    const int BROADCAST_PORT=3639 ;//designated port for xAP sending UDP packets
    
    EthernetInterface eth;
    eth.init();//use DHCP
    //printf("result from init %d\r\n",eth.init("172.20.177.241 ", "255.255.255.0", "172.20.177.1"));
    //printf("IP Address is %s\r\n", eth.getIPAddress());
    //printf("gateway is %s\r\n", eth.getGateway());
    //printf("mask is %s\r\n", eth.getNetworkMask());
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    
    UDPSocket udp;
    udp.init();
    printf("broadcasting success? %d \n", udp.set_broadcasting(true));
    Endpoint broadcast;
    printf("set address result %d\n",  broadcast.set_address("255.255.255.255", BROADCAST_PORT));
    
    
    
    char *packet_a = "xap-header\n"
                 "{\n"
                         "v=12\n"
                         "hop=1\n"
                         "uid=FF101200\n"
                         "class=SMS.Message\n"
                         "source=georg.mbedlpc1768.ibutton7E\n"
                 "}\n"
                 "Outbound\n"
                 "{\n"
                    "msg=(This is an xAP message from mbed, Ethernet connected!)\n"
                    "num=(00447401696842)\n"   
                 "}\n";
    
        printf("Broadcasting...\n");
        printf( "bytes sent= %d\n",udp.sendTo(broadcast, packet_a, strlen(packet_a)));
        


            
// xAP message composed to send warning email once a certain temperature condition is met.
           char *packet = "xap-header\n"
                 "{\n"
                         "v=12\n"
                         "hop=1\n"
                         "uid=FF89EA00\n"
                         "class=Mail.Outgoing \n"
                         "source=georg.mbedlpc1768.ibutton7E\n"
                 "}\n"
                "Message\n"
                 "{\n"
                 "To=(xxxxxxx@student.gla.ac.uk)\n"
                 "From=(Email From: temperature monitor )\n"
                 "Subject=(Email Subject: Temperature Alert)\n"
                 "CC=(example@gmail.com)\n"
                 "}\n"

               "Body.Text\n"
                "{\n"
                "Text.1=(The temperature xxx is exceeding safety limit)\n"
                "Text.2=(The current temperature is xxx)\n"
                "}\n"
                "Signature\n"
                "{\n"
                "Text.1=(iButton sensors)\n"
                "Text.2=(ID 7E00080292A87A10)\n"  
                "}\n";
while(true){
    printf("tem is %f \r\n", temperature);
      
    reset_thread();
    if(temperature> 17.0){
                            
                            printf("temperature alart\n");
                            printf( "bytes sent= %d\n",udp.sendTo(broadcast, packet, strlen(packet)));
                            udp.sendTo(broadcast, packet, strlen(packet));
                            wait(1.0);
                        
                            }
    
    Websocket ws("ws://sockets.mbed.org:443/ws/georg/rw");//("ws://sockets.mbed.org/ws/georg/rw");
    ws.connect();
    
    sprintf(recv, "Temperature of device %llX is %f: \n",rom, temperature); //E000080292CA1010
    
    ws.send(recv);
    temperature =0;
    wait(2.0);
    }
    
    
    
} 