/**Author: Zhongying Qiao  
Date: 02/03/2014*/ 
#include "mbed.h" 
#include "rtos.h" 
#include "OneWire.h" 
#include "Network.h" 
#include "DS1920.h" 
 
Serial pc(USBTX, USBRX); 
 
DigitalOut led1(LED1); 
DigitalOut led2(LED2); 
DigitalOut led3(LED3); 
DigitalOut led4(LED4); 
 
Timeout t; 
float temperature=0.0; 
 
// one wire ONE 
OneWire owi(p21); 
OneWire_Instruction owtrans; 
OneWire_ROM rom; 
onewire::ds1920::scratchpad_t scratchpad; 
TransportSearchPersist search; 
osThreadId controlthread; 
 
 
char readbuffer[16]; 
 
 
//led1 flashing at incresing speed 
 
void device_detect(OneWire * which){ 
    osSignalSet(controlthread, 1); 
} 
 
void reset_thread() { 
        wait(3.0); 
        //owi.detecthandle = &device_detect; 
        //controlthread = Thread::gettid(); 
        //Thread::signal_wait(0); 
        //osSignalSet(controlthread, 0); 
        led4 = 1; 
        search.clear(); 
        while(!search.done){ 
                OWNetwork::search(&owtrans, &search); 
                OWNetwork::no_transport(&owtrans); 
                if(owi.send(&owtrans, 1)){ 
                    if(owi.error == NO_PRESENCE) puts("device might have been removed\r"); 
                    else if(owi.error == CRC_ERROR) puts("results may have been comprimised by a transmission error\r"); 
                    else puts("UNEXPECTED ERROR\r"); 
                    break; 
                } 
                else{ 
                    if((uint64_t)search.rom == 0){ 
                        puts("the line was grounded\r"); 
                        break; 
                    } 
                        printf("detected device %llX\r\n", (uint64_t)search.rom); 
                        rom = search.rom; 
                        OWNetwork::match(&owtrans, &rom); 
                        onewire::ds1920::convert_temperature(&owtrans); 
                    if(owi.send(&owtrans, 1)){ 
                        puts("an error occured sending measure temperature transaction\r"); 
                        break; 
                    } 
                        Thread::wait(1000); 
                        onewire::ds1920::read_scratchpad(&owtrans, &scratchpad); 
                    if(owi.send(&owtrans, 1)){ 
                        puts("an error occured reading the scratchpad\r"); 
                        break; 
                    } 
                         
                        temperature= scratchpad.temperature_accurate(); 
                        printf("Temperature measured at %f degrees C.\r\n", temperature); 
                         
                    } 
        } 
} 