/* mbed Trigonometric constants and utilities
 * remi cormier 2012
 */

#ifndef MBED_TRIGO_H
#define MBED_TRIGO_H

/** Example code
* @code
#include "mbed.h"
#include "Trigo.h"

Serial pc(USBTX, USBRX);
Timer chrono;

const float Dmax = 1.0;
float N = 1;
const float pas=Dmax/N;
float X;
float Y;
float Z;
float R;
float A;
float B;

int main() {

pc.baud(115200);

// print pi do PC
pc.printf("pi = %.9f\n\r",Pi);

// Recpol dand PolRec test
pc.printf("RecPol et PolRec\n\r");
for(float i=-N; i<=N; i+=1)
{
 for (float j=-N; j<=N;j+=1)
{X=i*pas;
 Y=j*pas;
 RecPol(X,Y,&R,&A);
 pc.printf("X : %+.9f Y : %+.9f R : %+.9f A : %+9.4f\n\r",X,Y,R,A/degre);
 PolRec(R,A,&X,&Y);
 pc.printf("X : %+.9f Y : %+.9f R : %+.9f A : %+9.4f\n\r",X,Y,R,A/degre);
}}
pc.printf("\n\r");

// RecSph and SphRec test
pc.printf("RecSph et SphRec\n\r");

for (float i=-N;i<=N;i+=1)
    {for (float j=-N;j<=N;j+=1)
        {for (float k=-N;k<=N;k+=1)
            {X=i*pas;
             Y=j*pas;
             Z=k*pas;
             RecSph(X,Y,Z,&R,&A,&B);
             pc.printf("X : %+.9f Y : %+.9f Z : %+.9f R : %+.9f A : %+9.4f B : %+9.4f\n\r",X,Y,Z,R,A/degre,B/degre);
             SphRec(R,A,B,&X,&Y,&Z);
             pc.printf("X : %+.9f Y : %+.9f Z : %+.9f R : %+.9f A : %+9.4f B : %+9.4f\n\r",X,Y,Z,R,A/degre,B/degre);
            }
        }
    }

float dm=-4852.8359;

pc.printf("dm2dec(%f) = %f",dm,dm2dec(dm));

}




* @endcode
*/


/** Pi
*
* @param pi : pi
*/
const float Pi     = 3.141592653590;

/** pi/2
*
* @param halfPi : pi/2
*/
const float halfPi = Pi/2.0;

/** 2 pi
*
* @param twoPi : 2*pi
*/
const float twoPi  = 2.0*Pi;

/** degre
*
* @param degre = pi/180
*/
const float degre  = Pi/180.0;

/** degre ASCII symbol
*
* @param degre_symbol = '°'
*/
const char degre_symbol = 0xF8;

/** rectangular to polar coordinates (r : radius, a : angle) transform
*
* @param x : x coordinate
* @param y : y coordinate
* @param r : radius 
* @param a : angle (radian, counterclockwise)
*/
void RecPol(float x, float y, float *r, float *a);

/** polar to rectangular coordinates transform
*
* @param r : radius
* @param a : angle (radian, counterclockwise)
* @param x : x coordinate
* @param y : y coordinate
*/
void PolRec(float r, float a, float *x, float *y);

/** Rectangular to spherical coordinates transform
* 
* @param x : x coordinate
* @param y : y coordinate
* @param z : z coordinate
* @param r : radius
* @param a : angle in xy plane (longitude) ; radian counter clockwise
* @param b : angle above xy plane ; radian
*/
void RecSph(float x, float y, float z, float *r, float *a, float *b);

/** Spherical to rectangular coordinates transform
* 
* @param r : radius
* @param a : angle in xy plane (longitude) ; radian counter clockwise
* @param b : angle above xy plane ; radian
* @param x : x coordinate
* @param y : y coordinate
* @param z : z coordinate
*/


void SphRec(float r, float a, float b, float *x, float *y, float *z);

/** sexagesimal to decimal
*
* @param  dm : ddmm.mmmm
* @return d.ddddd
*/

float dm2dec(float dm);

#endif

