#include "mbed.h"
#include "Trigo.h"

// Trigo Library
// trigonometric constants and utilities
// rémi cormier 2012

void RecPol(float x, float y, float *r, float *a)
{*r=sqrt(x*x+y*y);
if (x==0.0)
    {if (y==0.0)
        {*a=0.0;}
     else   
        {if (y>=0.0)
            {*a=halfPi;}
        else
            {*a=-halfPi;}}}
else
    {*a=atan(y/x);
    if(x<0)
        {*a=Pi+*a;}
    if (*a>Pi)
        {*a=*a-twoPi;}
    }   
}

void PolRec(float r, float a, float *x, float *y)
{*x=r*cos(a);
 *y=r*sin(a);
}

void RecSph(float x, float y, float z, float *r, float *a, float *b)
{RecPol(x,y,b,a);
 RecPol(*b,z,r,b);
}

void SphRec(float r, float a, float b, float *x, float *y, float *z)
{PolRec(r,b,x,z);
 PolRec(*x,a,x,y);
}

float dm2dec(float dm)
    {float s;
     if (dm<0)
        {dm=-dm;
         s=-1;}
     else
        {s=1;}    
    float deg=floor(dm/100);
    dm=dm-deg*100;
    return(s*(deg+dm/60));
    }