#include "mbed.h"
#include "EPD_GDE021A1.h"

// praduitorilor!

#define EPD_CS       PA_15
#define EPD_DC       PB_11
#define EPD_RESET    PB_2
#define EPD_BUSY     PA_8
#define EPD_POWER    PB_10
#define EPD_SPI_MOSI PB_5
#define EPD_SPI_MISO PB_4
#define EPD_SPI_SCK  PB_3

EPD_GDE021A1 epd(EPD_CS, EPD_DC, EPD_RESET, EPD_BUSY, EPD_POWER, EPD_SPI_MOSI, EPD_SPI_MISO, EPD_SPI_SCK);

DigitalOut led1(LED1);

//width 48
//height 26
static uint8_t Battery_img[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xfe, 0xff, 0xff, 0xff, 0xff, 0x0f, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x0c, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x18, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0xff, 0x39, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x18, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x0c, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x0c, 
0xfe, 0xff, 0xff, 0xff, 0xff, 0x0f, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

int main()
{
    led1 = 1;
    
    epd.Clear(EPD_COLOR_WHITE);  
    epd.DisplayStringAtLine(5, (uint8_t*)"MBED", CENTER_MODE);
    epd.DisplayStringAtLine(3, (uint8_t*)"Epaper display", LEFT_MODE);
    epd.DisplayStringAtLine(2, (uint8_t*)"demo", LEFT_MODE);
    epd.DrawImage(130, 0, 48, 26, Battery_img);
    epd.DrawRect(50, 4, 60, 4);
    epd.RefreshDisplay();
    wait(2);
  
    while(1) {
        led1 = !led1;
        wait(1);
    }
}
