#include "mbed.h"
#ifndef funcion_comun
#define funcion_comun

SPI deviceM(PB_15, PB_14, PB_13);//puertos usados para conectar la matriz
DigitalOut ssel (PB_12);//puertos usados para conectar la matriz
AnalogIn vrx(A0);//puertos de entrada para lectura del joystick
AnalogIn vry(A1);//puertos de entrada para lectura del joystick

double mx;//variable donde se guarda los voltajes leidos
double my;//variable donde se guarda los voltajes leidos

void sendSPI(uint8_t d1, uint8_t d2)//envia datos a la tarjeta, cierra y abre puertos
{
    deviceM.unlock();
    ssel=0;
    deviceM.write(d1); 
    deviceM.write(d2);
    ssel=1;
    deviceM.lock();
}

void test()  //Test
{
    sendSPI(0x09,0);        //No decodificacion
    sendSPI(0x0B,0x07);     //Usa 8 leds                     
    sendSPI(0x0C,1);        //No se apaga
    sendSPI(0x0A,0x3);
        for (int i=0;i<2;i++)
        {
        sendSPI(0x0F,1);
        wait (0.1);
        sendSPI(0x0f,0);
        wait (0.1);    
        } 

}
void borrar() //borra toda la matriz;
{
    for(int i=0;i<=8;i++)//contador para recorrer posiciones
    {
        sendSPI(0x0+i,0x00);//recorre bit por bit colocando solo 0
    }
} 
 void analogo()//lee los voltajes generados por el joystick, con un valor de 0 a 1
  {
      mx=vrx.read();//lectura del volytaje en el eje x
      my=vry.read();//lectura del voltaje en el eje y
  }
#endif 