#include "mbed.h"
#include "Driver.h"

Driver::Driver(PinName M1A, PinName M1B, PinName M2A, PinName M2B):
            M1A(M1A), M1B(M1B), M2A(M2A), M2B(M2B){
    setPeriod_ms(1000);               
}

void Driver::setPeriod_ms(int32_t period){
    _period = period;
    M1A.period_ms(_period);
    M1B.period_ms(_period);
    M2A.period_ms(_period);
    M2B.period_ms(_period);
}

void Driver::neutral(){
    M1A.write(0);
    M1B.write(0);
    M2A.write(0);
    M2B.write(0);
}

void Driver::forward(float dutyCycle1, float dutyCycle2){
    _dutyCycle1 = dutyCycle1;
    _dutyCycle2 = dutyCycle2;
    if(_dutyCycle1 > 1.0f)
        _dutyCycle1 = 1.0f;
    if(_dutyCycle2 > 1.0f)
        _dutyCycle2 = 1.0f;
    if(_dutyCycle1 < 0)
        _dutyCycle1 = 0.0f;
    if(_dutyCycle2 < 0)
        _dutyCycle2 = 0.0f;
        
    M1A.write(_dutyCycle1);
    M1B.write(0);
    M2A.write(_dutyCycle2);
    M2B.write(0);
}

void Driver::backward(float dutyCycle1, float dutyCycle2){
    _dutyCycle1 = dutyCycle1;
    _dutyCycle2 = dutyCycle2;
    if(_dutyCycle1 > 1.0f)
        _dutyCycle1 = 1.0f;
    if(_dutyCycle2 > 1.0f)
        _dutyCycle2 = 1.0f;
    if(_dutyCycle1 < 0)
        _dutyCycle1 = 0.0f;
    if(_dutyCycle2 < 0)
        _dutyCycle2 = 0.0f;
        
    M1A.write(0);
    M1B.write(_dutyCycle1);
    M2A.write(0);
    M2B.write(_dutyCycle2);   
}

void Driver::right(float dutyCycle1, float dutyCycle2){
    _dutyCycle1 = dutyCycle1;
    _dutyCycle2 = dutyCycle2;
    if(_dutyCycle1 > 1.0f)
        _dutyCycle1 = 1.0f;
    if(_dutyCycle2 > 1.0f)
        _dutyCycle2 = 1.0f;
    if(_dutyCycle1 < 0)
        _dutyCycle1 = 0.0f;
    if(_dutyCycle2 < 0)
        _dutyCycle2 = 0.0f;
        
    M1A.write(0);
    M1B.write(_dutyCycle1);
    M2A.write(_dutyCycle2);
    M2B.write(0);
}

void Driver::left(float dutyCycle1, float dutyCycle2){
    _dutyCycle1 = dutyCycle1;
    _dutyCycle2 = dutyCycle2;
    if(_dutyCycle1 > 1.0f)
        _dutyCycle1 = 1.0f;
    if(_dutyCycle2 > 1.0f)
        _dutyCycle2 = 1.0f;
    if(_dutyCycle1 < 0)
        _dutyCycle1 = 0.0f;
    if(_dutyCycle2 < 0)
        _dutyCycle2 = 0.0f;
        
    M1A.write(_dutyCycle1);
    M1B.write(0);
    M2A.write(0);
    M2B.write(_dutyCycle2);
}