#include "mbed.h"

class Servo{

    public:
    
        Servo(PinName pin);             // Crea el objeto del tipo Servo especificando el pin del PWM. 
    
        void calibrate(int, int);       // Calibra los grados máximos y mínimos que recorrerá el servo.
        void goTo(int);                 // Establece la posicion del servo en grados.
        void write(int);                // Establece el ciclo útil del PWM en microsegundos.   
        int readPosition();             // Devuelve la posición actual del servomotor en grados. 
        int readPulseWidth();           // Devuelve el valor en microsegundos del ancho del PWM.
    
    protected:
    
        PwmOut _pwm;        // Crea el objeto para PWM de salida
        int _period;        // Almacena el valor del periodo del PWM
        int _min;           // Almacena el valor mínimo del ciclo útil
        int _max;           // Almacena el valor máximo del ciclo útil
        int _degrees;       // Almacena la posición en grados
        int _maxDegree;     // Almacena el valor máximo en grados
        int _minDegree;     // Almaecna el valor mínimo en grados
        int _microSeconds;  // Almacena el valor en micro segundos del ciclo útil
};

