#include "mbed.h"
#include "Servo.h"

Servo::Servo(PinName pin): _pwm(pin)
{
    _period = 25;           // 25ms
    _min = 500;             // 500us
    _max = 2500;            // 2500us
    _degrees = 0;
    _microSeconds = _min;
    _maxDegree = 180;
    _minDegree = 0;
    
    _pwm.period_ms(_period);
    write(_microSeconds);
}

void Servo::calibrate(int minDegree, int maxDegree){
    if(minDegree < 0)
        minDegree = 0;
    if(maxDegree > 180)
        maxDegree = 180;
        
    _minDegree = minDegree;
    _maxDegree = maxDegree;
    
    goTo(_minDegree);
}

void Servo::goTo(int degrees)
{
    _degrees = degrees;

    if(_degrees > _maxDegree)
        _degrees = _maxDegree;

    if(_degrees < _minDegree)
        _degrees = _minDegree;

    _microSeconds = ((_degrees - 0)*(_max - _min)/(180 - 0)) + _min;

    write(_microSeconds);
}

void Servo::write(int microSeconds)
{
    _microSeconds = microSeconds;

    if(_microSeconds < _min)
        _microSeconds = _min;

    if(_microSeconds > _max)
        _microSeconds = _max;

    _pwm.pulsewidth_us(_microSeconds);
}

int Servo::readPosition()
{
    return _degrees;
}

int Servo::readPulseWidth()
{
    return _microSeconds;
}
