#include "mbed.h"
#include "ESC.h"

ESC::ESC(PinName _pin): _pwmPin(_pin){
    _pwmPin.period_us(_period);
    init();
}

bool ESC::init(){
    _pwmPin.pulsewidth_us(1000);
    wait_ms(5000);
    return true;
}

void ESC::speed(float speed){
    _speed = speed;
    
    if(_speed > 1.0f)
        _speed = 1.0f;
    else if(_speed < 0.0f)
        _speed = 0.0f;
        
    _speed = (speed * 1000) + 1000;
    _pwmPin.pulsewidth_us(_speed);
}