/*
Poblema:
En un tanque de proceso, el producto que reposa en él debe cumplir condiciones, las cuales tenemos:

La temperatura debe estar entre 0 - 5 °C.
La presion debe cumplir de 4 a 20 BAR.
El nivel del producto sólo es indicativo.
Si el proceso varía estas condiciones mostrarán mensajes de error como advertencia o alerta para el operador.
*/

#include "mbed.h"   // libreria mbed
#include "NextionLCD.h" // libreria NextionLCD (Básica)
NextionLCD lcd(PB_6, PB_7);     //Tx, Rx

int main()
{
    char str[20];
    float v_Temp;
    float v_Presion;
    float v_Nivel;

    float Temperatura;
    float Presion;
    float Nivel;

    DigitalOut myled(PD_13); // Asignar salida digital al pin PD 13
    DigitalOut myled2(PD_12); // Asignar salida digital al pin PD 13
    AnalogIn Ain(PB_0); // Variable (Ain) para Entrada Analógica en el puerto PB_0
    AnalogIn Ain1(PB_1); // Variable (Ain) para Entrada Analógica en el puerto PB_0
    AnalogIn Ain2(PC_4); // Variable (Ain) para Entrada Analógica en el puerto PB_0
    v_Temp=0;
    v_Presion=0;
    v_Nivel=0;
    Temperatura=0;
    Presion=0;
    Nivel=0;

    lcd.ClrScr(BLACK);  //clear the display and fill it with BLACK pixels

    //draw some shapes
    //lcd.FillCircle(100,100,50,RED);
    //lcd.DrawPixel(100,100,WHITE);
    //lcd.DrawRectangle(50,50,100,100,BLUE);
    //lcd.DrawLine(50,50,100,150,YELLOW);

    /** Draws a string on the lcd at the specified xy position.
        * @param x x position.
        * @param y y position.
        * @param w Width of string area.
        * @param h Height of string area.
        * @param font Font ID to use (0:smallest - 7:largest).
        * @param fontcolor Color Integer value (0 to 65535) to represent the font color of the string - represented in 16-bit 565 color format.
        * @param backcolor Color Integer value (0 to 65535) to represent the background color of the string - represented in 16-bit 565 color format.
        * @param xcenter Horizontal alignment (0: left-aligned, 1: entered, 2: right-aligned).
        * @param ycenter Vertical alignment (0: upper-aligned, 1: entered, 2: lower-aligned).
        * @param str String content.
        */
    //void DrawString(uint16_t x, uint16_t y, uint16_t w, uint16_t h, uint8_t font, uint16_t fontcolor, uint16_t backcolor, uint8_t xcenter, uint8_t ycenter, char *str);
    //str.printf("hola mundo");
    //lcd.DrawString(0,0,50,50,20,20,20,20,20,str);

    while(1) {
        sprintf(str, "PROYECTO SISTEMAS MICROPROCESADOS"); //print to string buffer
        lcd.DrawString(10,0,300,50,0,WHITE,BLACK,0,0,str);            //display string on LCD:

        v_Temp=Ain;
        v_Presion=Ain1;
        v_Nivel=Ain2;
        myled = 1; //Asigna el valor de 1 (ON) a la variable "myled"
        wait(0.1); //Línea de espera (ms)
        //sprintf(str, "El valor analogico en voltaje es: %f",v_analogico); //print to string buffer
        //lcd.DrawString(40,100,250,20,0,GREEN,GRAY,0,0,str);            //display string on LCD:
        myled = 0; //Asigna el valor de 1 (ON) a la variable "myled"
        wait(0.1); //Línea de espera (ms)

        //Escalar variable de entrada
        Temperatura= v_Temp*10;
        Presion= v_Presion*50;
        Nivel= v_Nivel*12;

        myled = 1; //Asigna el valor de 1 (ON) a la variable "myled"
        wait(0.1); //Línea de espera (ms)

        sprintf(str,"El valor de Temperatura es: %0.1f C",Temperatura); //print to string buffer
        lcd.DrawString(40,150,250,20,0,WHITE,GRAY,0,0,str);            //display string on LCD:
        myled = 0; //Asigna el valor de 1 (ON) a la variable "myled"
        wait(0.1); //Línea de espera (ms)

        sprintf(str, "El valor de Presion es: %0.2f BAR",Presion); //print to string buffer
        lcd.DrawString(40,170,250,20,0,WHITE,GRAY,0,0,str);            //display string on LCD:
        myled = 1; //Asigna el valor de 1 (ON) a la variable "myled"
        wait(0.1); //Línea de espera (ms)

        sprintf(str, "El valor de nivel es: %0.3f m",Nivel); //print to string buffer
        lcd.DrawString(40,190,250,20,0,WHITE,GRAY,0,0,str);            //display string on LCD:
        //myled = 0; //Asigna el valor de 1 (ON) a la variable "myled"
        //wait(0.1); //Línea de espera (ms)


        //Condiciones del proceso:
        if (Temperatura >= 5 && Temperatura<=10 && Presion >= 20 && Presion <= 50) {
            sprintf(str, "ERROR EN PROCESO"); //print to string buffer
            lcd.DrawString(40,30,250,20,0,RED,GRAY,0,0,str);            //display string on LCD:
        } 
        if (Temperatura >= 0 && Temperatura<5) {
            sprintf(str, "TEMPERATURA ESTABLE"); //print to string buffer
            lcd.DrawString(40,70,250,20,0,GREEN,GRAY,0,0,str);            //display string on LCD:
        } 
        if (Temperatura >= 5 && Temperatura <= 10) {
            sprintf(str, "TEMPERATURA ELEVADA"); //print to string buffer
            lcd.DrawString(40,70,250,20,0,RED,GRAY,0,0,str);            //display string on LCD:
        } 
        if (Presion >= 4 && Presion <= 20) {
            sprintf(str, "PRESION ESTABLE"); //print to string buffer
            lcd.DrawString(40,100,250,20,0,GREEN,GRAY,0,0,str);            //display string on LCD:
        }
        if (Presion > 20 && Presion <= 40) {
            sprintf(str, "PRESION ELEVADA"); //print to string buffer
            lcd.DrawString(40,100,250,20,0,YELLOW,GRAY,0,0,str);            //display string on LCD:
        }
        if (Presion > 40 && Presion <= 50) {
            sprintf(str, "SOBREPRESION"); //print to string buffer
            lcd.DrawString(40,100,250,20,0,RED,GRAY,0,0,str);            //display string on LCD:
        }
     }
}