#include "mbed.h"
InterruptIn sensor(PD_12); // Entrada digital que activa la interrupción
Serial pc(PA_2,PA_3,115200); // Variable (pc) para comunicación serial PA_2 y PA_3 a una velocidad de 115200 
DigitalOut alarma_interrup(PD_13); // Pin digital de salida, variable alarma_interrup direccionado al pin PD_13 
DigitalOut led(PD_14); // Pin digital de salida, variable LED al pin PD_14 simulando un ejecución de programa 

int Contador = 0;  // variable entera llamada Contador
void activa(void); // Llamado de función "activa"

int main()
{
    sensor.rise(&activa); // Relaciona la señal de interrupción y la función creada
    
    while(1) {  // Desarrollo del programa base.
        led = 1;
        wait(0.2);
        led = 0;
        wait(0.2);
    }
}

void activa() // Ejecución de la función "activa"
/*
Activa un señal de alarma,  y envía un conteo por medio del 
puerto serial; esto puede ser mostrado por el programa Hercules Utilities.

*/
{
    alarma_interrup = 1;
    wait(0.2);
    alarma_interrup = 0;
    Contador = Contador++; // Contador aumentando el valor en 1
    pc.printf("El programa se ha interrumpido %d veces\n\r",Contador); // Cadena de caracteres enviadas por el puerto serial
}

