#include "mbed.h"
#include "IR.h"
#include "IRSender.h"

#define LOG_LEVEL_ERROR
#include "Log.h"

#define WORD(x, i) ((x)[(i)] << 8 | (x)[(i) + 1])

IRSender senderPin(p14);
Serial px(USBTX, USBRX);

#define SCR_1 1260, 420
#define SCR_0 420, 1260

#define SCR_RAW_CODE_DOWN   SCR_1, SCR_1, SCR_1, SCR_1, SCR_0, SCR_0, SCR_0, SCR_0, SCR_0, SCR_1, SCR_0, SCR_0
#define SCR_RAW_CODE_MIDDLE SCR_1, SCR_1, SCR_1, SCR_1, SCR_0, SCR_0, SCR_0, SCR_0, SCR_0, SCR_0, SCR_1, SCR_0
#define SCR_RAW_CODE_UP     SCR_1, SCR_1, SCR_1, SCR_1, SCR_0, SCR_0, SCR_0, SCR_0, SCR_0, SCR_0, SCR_0, SCR_1
#define SCR_PAUSE 0, 20 * 1680    

unsigned screen_down_raw_codes[50] = {
    SCR_RAW_CODE_DOWN,
    SCR_PAUSE,
    SCR_RAW_CODE_DOWN
};

unsigned screen_middle_raw_codes[50] = {
    SCR_RAW_CODE_MIDDLE,
    SCR_PAUSE,
    SCR_RAW_CODE_MIDDLE
};

unsigned screen_up_raw_codes[50] = {
    SCR_RAW_CODE_UP,
    SCR_PAUSE,
    SCR_RAW_CODE_UP
};



void fireIRCode(uint8_t* header, uint8_t* one, uint8_t* zero, uint8_t* ptrail, uint8_t* predata, uint8_t* code)
{
    
    if(code[0] == 17) {
        switch(code[1]) {
            case 17: senderPin.irSeq(26, 50, screen_up_raw_codes); break;
            case 18: senderPin.irSeq(26, 50, screen_middle_raw_codes); break;
            case 19: senderPin.irSeq(26, 50, screen_down_raw_codes); break;
        }
        return;
    } 
    
    LOG_INFO("Going to fire.\n");
    int raw_codes_length = 67;
    unsigned raw_codes[raw_codes_length];
    raw_codes[0] = WORD(header, 0);
    raw_codes[1] = WORD(header, 2);
    int offset = 2;
    for(int i = 0; i < 16 * 2; i += 2) {
        int bit = predata[i / 16] & 0x80;
        uint8_t* signal = bit ? one : zero;
        raw_codes[i + offset] = WORD(signal, 0);
        raw_codes[i + offset + 1] = WORD(signal, 2);
        predata[i / 16] <<= 1;
    }
    offset = 34;
    for(int i = 0; i <  16 * 2; i += 2) {
        int bit = code[i / 16] & 0x80;
        uint8_t* signal = bit ? one : zero;
        raw_codes[i + offset] = WORD(signal, 0);
        raw_codes[i + offset + 1] = WORD(signal, 2);
        code[i / 16] <<= 1;
    }
    raw_codes[66] = WORD(ptrail, 0);
    
    LOG_INFO("Full sequence received!\n");
    
    senderPin.irSeq(26, 67, raw_codes);


    LOG_INFO("Wrote message :)\n");
}