#include "mbed.h"
#include "IR.h"

#define LOG_LEVEL_ERROR
#include "Log.h"
#include "Puck.h"

Puck* puck = &Puck::getPuck();

const UUID IR_SERVICE_UUID = stringToUUID("bftj ir         ");
const UUID HEADER_UUID     = stringToUUID("bftj ir header  ");
const UUID ONE_UUID        = stringToUUID("bftj ir one     ");
const UUID ZERO_UUID       = stringToUUID("bftj ir zero    ");
const UUID PTRAIL_UUID     = stringToUUID("bftj ir ptrail  ");
const UUID PREDATA_UUID    = stringToUUID("bftj ir predata ");
const UUID CODE_UUID       = stringToUUID("bftj ir code    ");


void onIRCodeWrite(uint8_t* value) {
    puck->getBle().disconnect();
    LOG_INFO("Going to fire IR code...\n");
    fireIRCode(puck->getCharacteristicValue(HEADER_UUID),
               puck->getCharacteristicValue(ONE_UUID), 
               puck->getCharacteristicValue(ZERO_UUID),
               puck->getCharacteristicValue(PTRAIL_UUID),
               puck->getCharacteristicValue(PREDATA_UUID),
               puck->getCharacteristicValue(CODE_UUID));
    LOG_INFO("Fire complete!\n");
}


int main() {
    puck->addCharacteristic(IR_SERVICE_UUID, HEADER_UUID, 4);
    puck->addCharacteristic(IR_SERVICE_UUID, ONE_UUID, 4);
    puck->addCharacteristic(IR_SERVICE_UUID, ZERO_UUID, 4);
    puck->addCharacteristic(IR_SERVICE_UUID, PTRAIL_UUID, 2);
    puck->addCharacteristic(IR_SERVICE_UUID, PREDATA_UUID, 2);
    puck->addCharacteristic(IR_SERVICE_UUID, CODE_UUID, 2);
    puck->init(0xABBA);
    puck->onCharacteristicWrite(CODE_UUID, onIRCodeWrite);
    while (puck->drive());
}