#include "mbed.h"
#include "dlms_comms.h"
/** ---------------------------------------------------------------------------
 * @brief This module was tested on a Nucleo F030R8 with dual UARTS
 *  The debugger uart is the normal , and the second uart was used for
 *  RS485 communications
 * @note The ring buffers are 256 bytes, that implies that if an unsigned
 *       char is used as index , the ++index wraps automatically, is other
 *       ring buffer sizes is used, please wrap the head and tail indexes 
 *       appropiate 
 * @note The timer was instantiate and used dering debugging to display 
 *       the timing.. kept just for incase one needs it
**/

// instantiate classes
Timer       timer;
// debug serial comms
RawSerial   debugger(SERIAL_TX, SERIAL_RX);
// rs485 comms class on 2nd uart
dlms_comms  dlms;

DigitalOut myled(LED1);

#define POLL_TIME_MS  100
 
/** -------------------------------------------------------------------------
 * @brief the setup routine runs once when you press reset
 */
void setup(void)
{
    // initialize serial communication at 115200 bits per second:
    debugger.baud (115200);
    // use the defaults
    debugger.format();       
    // annouce yourself to the world                    
    debugger.printf ("\r\n\n>> Creatron RS485 test program Nov 2014  \r\n");
    // start the timer
    timer.start();
    // this allows the rs485 class to use the parent timer and printf classes
    // in this class
    dlms.init  ( &debugger, &timer);
    // initialise the rs485 class
    dlms.initialise  (9600, // baudrate    
                      8,    // bits,
                      'n',  // parity
                      1);   // stop_bits    
    debugger.printf (">> Setup Done \r\n");
}
/** ---------------------------------------------------------------------------
 * @brief  M A I N 
 */
int main(void)
{  
    // timer to do some timing
    UINT_64        compare_ms  = 0l;
    UINT_64        current_ms; 
    // my variable.. just a tester to 'see' the state of the RS485 transceiver
    bool           direction_485 = false;
    // char to command functions
    char           ch;
    
    // initialise 
    setup();
    debugger.printf (">> Ready.. \r\n"
                     "   Press 1 to send RS485 PacketDemo .. \r\n");
    // endless loop, glad I dont have to do this
    do
    {
         // use the timer to toggle I am alife led 
         current_ms = timer.read_ms();
         current_ms -= compare_ms;         
         if (current_ms > POLL_TIME_MS)
         {
             compare_ms += POLL_TIME_MS;
             if (myled) 
                myled = false;
             else
                myled = true;
         }
         
         // try to detect a direction change on the RS485 transceiver
         // and keep the user informed .. just for ammusement
         if (direction_485 != dlms.get_dir485())
         {
             direction_485 = dlms.get_dir485();
             debugger.printf("\r\n> Dir Changed ");
             if (direction_485)
                debugger.printf("1 \r\n");
             else
                debugger.printf("0 \r\n");
         }
         // check to see if the user has a 'request' to be executed
         if (debugger.readable())
         {
              ch = debugger.getc() & 0x7f;
              switch (ch)
              {
                 // fine .. 
                 case '1':
                    //  this was designed to send binary packets (structure), thus
                    // if you want to send null terminated strings one could
                    // just use the strlen() function for the amount of bytes 
                    // to be send, the transmission (send_packet) will happily send zeros 
                    dlms.send_packet ("\r\nSend test packet to RS485\r\n", 29);
                    break;
              }
              // show some stats .. keep em happy
              debugger.printf (">> %c 0x%02X IRQ rxcount=%5ld txcount=%5ld Dir_485=%d\r\n", ch, ch, 
                               dlms.ret_rx_irq_count(),
                               dlms.ret_tx_irq_count(),
                               dlms.ret_dir_485());
         }
         // if any char received on the RS485 bus, display it ..
         // assumes this is printable
         if (dlms.char_available())
         {
            ch = dlms.get_char();
            debugger.printf("RX Char %c 0x%02X\r\n", ch, ch);
         }
    }
    while (1);
}
 //----[ then end]-------------------------------------------------------------

 