#ifndef DLMS_COMMS_H
#define DLMS_COMMS_H

#include "types.h"

class dlms_comms
{
public:
    dlms_comms                 (void);
    void      initialise       (INT_16         baudrate,     
                                UINT_8         bits,
                                UINT_8         parity,
                                UINT_8         stop_bits); 
public:
    void      send_packet      (const UINT_8 * ptr,
                                const UINT_8   length);
    bool      char_available   (void);
    UINT_8    get_char         (void);
    void      init             (RawSerial    * parent_uart,
                                Timer        * parent_timer);
    bool      get_dir485       (void);
    UINT_64   ret_tx_irq_count (void);
    UINT_64   ret_rx_irq_count (void);
    bool      ret_dir_485      (void);
private:
    void      Rx_interrupt     (void);
    void      Tx_interrupt     (void);
    // parent classes 
    RawSerial * debug_uart;
    Timer     * timer;
    UINT_8      rx_buffer[256];
    UINT_8      rx_head_ptr;
    UINT_8      rx_tail_ptr;                           

    volatile UINT_64     tx_irq_count;
    volatile UINT_64     rx_irq_count;
};
#endif
