#define True 1
#define False 0
#include "mbed.h"
#include "MODSERIAL.h"



MODSERIAL pc(USBTX,USBRX,512);
Ticker tmer;
DigitalOut rUSB(p14);


float FirmVer=1.6;
char buf[513];
volatile int sFlag=0;
int Diagnostic=0;



struct tm t;
time_t seconds;

int HoldOFF;


void update_cfg();
void save_cfg();
void restore_cfg();
void ADCInit();
void DACInit();
void SerialInit();
void EEInit();
void RTCInit();
void ADCint();
void DACwr(int Ch, int Val);
void parse();

void PIDcalc(int eCh, int sCh, int Cntl);
void SysInit();

void rxCallback(MODSERIAL_IRQ_INFO *info);
void flushSerialBuffer(void);
extern "C" void HardFault_Handler()
{
    pc.printf("Error Hard Fault!\n");
    //NVIC_SystemReset();
}
extern "C" void NMI_Handler()
{
    pc.printf("Error NMI Fault!\n");
    //NVIC_SystemReset();
}
extern "C" void MemManage_Handler()
{
    pc.printf("Error MemManage Fault!\n");
    //NVIC_SystemReset();
}
extern "C" void BusFault_Handler()
{
    pc.printf("Error BusFault Fault!\n");
    //NVIC_SystemReset();
}
extern "C" void UsageFault_Handler()
{
    pc.printf("Error UsageFault Fault!\n");
    //NVIC_SystemReset();
}

int main()
{
    rUSB=1;

    FirmVer=1.6;  //Firmware Version
    SerialInit();
    SysInit();
    RTCInit();
    HoldOFF=0;
    flushSerialBuffer();

    while (1) {
        wait(.1);
        if (sFlag==1) {
            //  NVIC_DisableIRQ(UART0_IRQn);    //added to fix lockup 9-27-11
            int nNum = pc.move(buf,512);
            buf[nNum] = '\0';
            pc.printf("\n\r%s\n\r",buf);
            parse();
            sFlag=0;
            //  NVIC_EnableIRQ(UART0_IRQn);     //added to fix lockup 9-27-11
        }
        seconds  = time(NULL);


    }
}

void flushSerialBuffer(void)
{
    char char1 = 0;
    while (pc.readable()) {
        char1 = pc.getc();
    }
    return;
}

void SysInit()
{

}

void RTCInit()
{

    t.tm_sec = 00;    // 0-59
    t.tm_min = 00;    // 0-59
    t.tm_hour = 12;   // 0-23
    t.tm_mday = 12;   // 1-31
    t.tm_mon = 5;     // 0-11
    t.tm_year = 109;  // year since 1900
    seconds = mktime(&t);
    set_time(seconds);

}





void ADCint()
{

    if (Diagnostic==0) {
        PIDcalc(0, 1, 0);
        PIDcalc(2, 3, 1);
    }

}

void PIDcalc(int eCh, int sCh, int Cntl)
{

}



void SerialInit()
{
    pc.baud(115200);
    pc.autoDetectChar('\r');
    pc.attach(&rxCallback, MODSERIAL::RxAutoDetect);

}

void rxCallback(MODSERIAL_IRQ_INFO *info)
{
    sFlag=1;
}

void parse()
{

    char *pos;
    char key[]="Tt";
    pos=strpbrk(buf,key);
    if (pos) {
        //__NVIC_DisableIRQ(UART0_IRQn);
        //  pc.printf("%c",0x0c);
        pc.printf("hello you pressed T\n\r");
        //__NVIC_EnableIRQ(UART0_IRQn);
    } else {
        char key[]="Rr";
        pos=strpbrk(buf,key);
        if (pos) {
            //__NVIC_DisableIRQ(UART0_IRQn);
            //  pc.printf("%c",0x0c);
            pc.printf("hello you pressed R\n\r");
            //__NVIC_EnableIRQ(UART0_IRQn);
        } else {
            char key[]="sS";
            pos=strpbrk(buf,key);
            if (pos) {
                pc.printf("hello you pressed S\n\r");
            } else {
                char key[]="pP";
                pos=strpbrk(buf,key);
                if (pos) {
                    pc.printf("hello you pressed P\n\r");
                } else {
                    char key[]="dD";
                    pos=strpbrk(buf,key);
                    if (pos) {
                        pc.printf("hello you pressed D\n\r");
                    } else {
                        char key[]="iI";
                        pos=strpbrk(buf,key);
                        if (pos) {
                            pc.printf("hello you pressed I\n\r");
                        } else {
                            char key[]="qQ";
                            pos=strpbrk(buf,key);
                            if (pos) {
                                pc.printf("hello you pressed q\n\r");
                            } else {
                                //__NVIC_DisableIRQ(UART0_IRQn);
                                pc.printf("\n\rErr. %s\n\r",buf);
                                //__NVIC_EnableIRQ(UART0_IRQn);
                            }
                        }
                    }
                }
            }
        }
    }
}