#include "mbed.h"

//{/*** Bit Banding *******************************************************/
/* base address for bit banding */
#define BITBAND_SRAM_REF                    (0x20000000)
/* base address for bit banding */
#define BITBAND_SRAM_BASE                   (0x22000000)
/* base address for bit banding */
#define BITBAND_PERIPH_REF                  (0x40000000)
/* base address for bit banding */
#define BITBAND_PERIPH_BASE                 (0x42000000)

/* sram bit band */
#define BITBAND_SRAM(address, bit)   ((void*)(BITBAND_SRAM_BASE + (((uint32_t)address) - BITBAND_SRAM_REF) * 32 + (bit) * 4))

/* periph bit band */
#define BITBAND_PERIPH(address, bit) ((void*)(BITBAND_PERIPH_BASE + (((uint32_t)address) - BITBAND_PERIPH_REF) * 32 + (bit) * 4))
//}/***********************************************************************/


// Initialise LED1 gpio
DigitalOut myled(LED1);

/* bit-band definition, LED1 is PA_5 */
#define LED_BB *((volatile unsigned char *)BITBAND_PERIPH(&GPIOA->ODR, 5))

int main() {
    while(1) {
        LED_BB = 1; // set led on
        wait(0.2);
        LED_BB = 0; // clear led
        wait(0.2);
    }
}
