#include "mbed.h"

Serial dialog(PB_6, PB_7);
Serial pcc(USBTX, USBRX);
DigitalOut myled(LED1);

char ch;
const int  PACKET_SIZE = 3;
char dialog_RxBuf[PACKET_SIZE];
volatile int dialog_RxLen = 0;
int index = 0;

void dialog_Rx(void)
{
    wait(.4);
    
    if(dialog.readable())
        {
        char c = dialog.getc();
            
            switch(c)
                {
                case '*':
                   do
                   {
                        pcc.printf("\r\n stuck in this do loop...");
                        if (dialog.readable())  // NOTE: NOT MAKING IT INTO THIS "IF" STATMENT
                            {
                            ch = dialog.getc();   // read it
                            if (index < PACKET_SIZE)          // to avoid buffer overflow
                                dialog_RxBuf[index++]=ch;     // put it into the value array and increment the index
                                pcc.printf("\r\n Did it make it in here?");
                            }
                    } while (ch!='\n');
                    break;
                default:
                    pcc.putc(c);
                    break;
                }
        }
               
}



int main()
{
    dialog.baud(9600);  
    pcc.baud(9600);
    dialog.attach(&dialog_Rx); // Attach UART receive interrupt


    __disable_irq();

    dialog.puts("*12\n");  // Put in a string in the UART buffer
    wait(1);    

    __enable_irq();        
   
    myled = 0;
    wait(0.5);
    myled = 1;
    wait(0.5);
}
    
