#ifndef DOF9_RAZOR_IMU_H
#define DOF9_RAZOR_IMU_H

//****************************************************************************/
// Includes
//****************************************************************************/
#include "mbed.h"

//****************************************************************************/
// Defines
//****************************************************************************/

class dof9RazorImu {
#define BAUD_RATE     38400 //Default in frimware from SparkFun.
#define DOFFW 0// 1 PARA MODIFICADO
public:

    /**
     * Constructor.
     *
     * Parameters:
     *
     *  tx - Pin to use for Serial transmission.
     *  rx - Pin to use for Serial receive.
     */
    dof9RazorImu(PinName tx, PinName rx);

    /**
     * Update all of the heading data.
     */
    void update(void);

    int getGyroX(void);
    int getGyroY(void);
    int getGyroZ(void);

    int getAccX(void);
    int getAccY(void);
    int getAccZ(void);

    int getMagX(void);
    int getMagY(void);
    int getMagZ(void);

private:

    Serial* razor;

    int gyro_x;
    int gyro_y;
    int gyro_z;

    int acc_x;
    int acc_y;
    int acc_z;

    int mag_x;
    int mag_y;
    int mag_z;
};

#endif /* DOF9_RAZOR_IMU_H */