#include "UltraSonidos.h"
#include "mbed.h"


UltraSonidos::UltraSonidos(PinName pin) : _pinDigital(pin) {
  
}

long UltraSonidos::read(){

long duration;

  _pinDigital.output();
  _pinDigital = 0;
  wait_ms(2);
  _pinDigital = 1;
  wait_ms(5);
  _pinDigital = 0;


  _pinDigital.input();
  duration = pulseIn(_pinDigital);

  // convert the time into a distance
  
  return microsegundosAcentimetros(duration);
  
  
  

}

int UltraSonidos::pulseIn(DigitalInOut& pingPin) {
    Timer tmr;
    while (!pingPin); // wait for high
    tmr.start();
    while (pingPin); // wait for low
    return tmr.read_ms();
}


long UltraSonidos::microsegundosAcentimetros(long microsegundos)
{
  // The speed of sound is 340 m/s or 29 microseconds per centimeter.
  // The ping travels out and back, so to find the distance of the
  // object we take half of the distance travelled.
  return microsegundos / 29 / 2;
}