#include "mbed.h"
#include "Mx28.h"
#include <math.h>

// Dynamixel
#define SERVO_ID  3             // ID of which we will set Dynamixel too 
#define SERVO_ControlPin A2       // Control pin of buffer chip, NOTE: this does not matter becasue we are not using a half to full contorl buffer.
#define SERVO_SET_Baudrate 1000000  // Baud rate speed which the Dynamixel will be set too (1Mbps)
#define TxPin A0
#define RxPin A1
#define CW_LIMIT_ANGLE 0x001        // lowest clockwise angle is 1, as when set to 0 it set servo to wheel mode
#define CCW_LIMIT_ANGLE 0xFFF       // Highest anit-clockwise angle is 0XFFF, as when set to 0 it set servo to wheel mode
#define MAX_TORQUE_LIMIT 0x3FF
#define MIN_TORQUE_LIMIT 0x3FF

#define pi 3.14
#define Ts 1                          // 週期
#define A 25//15                         // angle
#define f 0.5                        // Hz
unsigned long tt = 0;
double deg = 0;
int Pos = 0;
int zero = 190;
char mode='a';
DynamixelClass dynamixelClass(SERVO_SET_Baudrate,SERVO_ControlPin,TxPin,RxPin);
DigitalIn mybutton(USER_BUTTON);
DigitalOut pin_pc2(PC_3);
//
// Interrupt
//Ticker timer1;
// timer 1
#define LOOPTIME  1000                         // 1 ms
unsigned long lastMilli = 0;
// sampling time
float T = 0.001;

Timer t;

int sensor_flag = 0;                 // sensor initial flag
int sensor_count = 0;
int i=0;


int main()
{
    dynamixelClass.setMode(SERVO_ID, SERVO, CW_LIMIT_ANGLE, CCW_LIMIT_ANGLE);    // set mode to SERVO and set angle limits
    dynamixelClass.setMaxTorque( SERVO_ID, MAX_TORQUE_LIMIT);
//    dynamixelClass.setPID(SERVO_ID,0,0,254);
//    timer1.attach_us(&timer1_interrupt, 10000);//10ms interrupt period (100 Hz)
//    USB.attach(&change_mode); //
//    dynamixelClass.torqueMode(SERVO_ID,OFF);
//    wait_ms(1);
//    dynamixelClass.setHoldingTorque(SERVO_ID,ON);
//    dynamixelClass.ledState(SERVO_ID,ON);
//    wait_ms(1);
    //dynamixelClass.torque(SERVO_ID,1023);
    t.start();
//    SW = 0;

    while(1) 
    {   
//        pin_pc2 = 0;
//        wait(0.2);
//        pin_pc2 = 1;
//        wait(0.2);
        //id 1:  5~55
        //id 2:  40~
//        deg = (45)*4096.0f/360.0f;
        deg = (100)*4096.0f/360.0f;
////                    case 'a':
////                        deg = (zero+60)*4096.0f/360.0f;
////                        break;
////                    case 'b':
////                        deg = (zero+10)*4096.0f/360.0f;
////                        break;
////                    case 'c':
////                        deg = (zero+45-A*sin(2*pi*f*tt*0.001*Ts))*4096.0f/360.0f;       // 在正負A度搖15
//                    case 'a':
////                        deg = (zero+60)*4096.0f/360.0f;
//                        break;
//                    case 'b':
//                        deg = (zero+10)*4096.0f/360.0f;
//                        break;
//                    case 'c':
//                        deg = (30-A*sin(2*pi*f*tt*0.001*Ts))*4096.0f/360.0f;       // 在正負A度搖15

                
                i++;
                if(i==5000)dynamixelClass.setHoldingTorque(SERVO_ID,ON);
                else if (i<5000)dynamixelClass.servo(SERVO_ID,deg,0x400);
                else;
}
}