#ifndef SENSORFUSION_H_INCLUDED
#define SENSORFUSION_H_INCLUDED

#include "math.h"
#define FTimer          1000.0f             ///Hz
#define sample_time     1.0f/FTimer
#define Alpha           FTimer/25.0f

extern float axm, aym, azm, u1, u2, u3, mx, my, mz;
extern float Ac[3];

extern float axm_f, axm_f_old, u3aym_f, u3aym_f_old, u2azm_f, u2azm_f_old;
extern float aym_f, aym_f_old, u3axm_f, u3axm_f_old, u1azm_f, u1azm_f_old;
extern float azm_f, azm_f_old, u2axm_f, u2axm_f_old, u1aym_f, u1aym_f_old;

extern float x1_hat, x2_hat, x3_hat;
extern float sinroll, cosroll, roll_angle, droll_angle, droll_angle_old;
extern float sinpitch, cospitch, yaw_ref, yaw_angle, yaw_angle_old, dyaw_angle, dyaw_angle_old;

//extern void CentrifugalAcce_Compensation(float velocity);
extern float lpf(float input,float input_old,float frequency);
extern void roll_fusion(float a_xm,float a_ym,float a_zm,float u_3,float u_1,float alpha);
extern float Determinant(float x11, float x12, float x21, float x22);
extern float absolute(float value);

extern void Reset_data(void);

#endif // SENSORFUSION_H_INCLUDED