#ifndef SYSTEMCONST_H_INCLUDED
#define SYSTEMCONST_H_INCLUDED

#define pi      3.14f

#define M       23.1f
#define J       5.2067f
#define g       9.81f
#define Xt      0.3857f
#define Zt      0.4338f
#define L       1.053f
#define lammda  20/180*pi

#define R_wheel 0.0695f  ///radius of wheels
#define l_rs    0.095f   ///length from rear wheel to sensor on XY plane
#define l_rg    0.13f    ///length from rear wheel to center of mass on XY plane
#define Vmin    0.5f
#define Vmax    5.0f


/*
    steer      u2steer_lpf_freq*speed                1
    ----- = ----------------------------- * --------------------
      u      S + u2steer_lpf_freq*speed      u2steer_gain*speed
*/
#define u2steer_lpf_freq    2.52668f//2.52668f
#define u2steer_gain        0.6251f

#endif // ROBOTBICYCLECONST_H_INCLUDED
