#ifndef ZTC_H_INCLUDED
#define ZTC_H_INCLUDED

#include "mbed.h"
#include "RobotBicycleConst.h"
#include "SensorFusion.h"

#define GAMMA_OFFSET    0.0f / 180.0f * 3.14159f
//#define GAMMA_OFFSET    -2

#define L_PD_OFFSET     5.0f / 180.0f * 3.14159f
#define DLT_GAMMA_REF   4.0f / 180.0f * 3.14159f

#define PHI_HAT_UB  0.1745f
#define PHI_HAT_LB  -PHI_HAT_UB
#define K_aw        500*pi_const

#define S_S     0       ///state of pedaling and controller
#define L_PD    1
#define M_PD    2
#define M_ZTC   3
#define H_PD    4
#define H_ZTC   5

///ZTC
extern float K_h[3];
extern float K_m[3];
extern float K_l[3];
extern float K_s[3];
extern float K_hphi[3];
extern float K_mphi[3];
extern float u;
extern float phi_hat;
extern float phi_hat_old;
extern float phi_hat_aw;
extern float dphi_hat;
extern float roll_ref;
extern float gamma_d;
extern float gamma_ref;
extern float gamma_ref_old;
extern float gamma_rad;
extern float gamma_rad_old;
extern int8_t gamma_degree;

extern void calc_PD(float* K, float phi_hat_in);
extern void calc_Phi(float* K_est);
extern void calc_Gamma(float u_in, float alpha, float multr);
extern void anti_wdup(void);
//extern AnalogIn VariableResistor1_value;

#endif // ZTC_H_INCLUDED