#ifndef SPI_9DSENSOR_H_INCLUDED
#define SPI_9DSENSOR_H_INCLUDED

#include "mbed.h" // GPIO

#define sensorG_CTRL_REG1_address    0x20
#define sensorXM_CTRL_REG0_address   0x1F
#define sensorG_OUT_X_L_address      0x28
#define sensorXM_OUT_X_L_A_address   0x28
#define sensorXM_OUT_X_L_M_address   0x08

#define CSG     0
#define CSXM    1

#define INDEX_GYRO_X    1
#define INDEX_GYRO_Y    2
#define INDEX_GYRO_Z    3
#define INDEX_ACCE_X    4
#define INDEX_ACCE_Y    5
#define INDEX_ACCE_Z    6
#define INDEX_MAGN_X    7
#define INDEX_MAGN_Y    8
#define INDEX_MAGN_Z    9

// sensor correction
#define GX_offset   50.095//35
#define GY_offset   56.249//same
#define GZ_offset   1.862//151
#define AX_offset   -651.6106//-715///-908
#define AY_offset   -697.9139//-501
#define AZ_offset   218.8919//215
#define MX_offset   136
#define MY_offset   -108
#define MZ_offset   -102

// Gain of Gyro and Acce
#define Mag_backgnd 0.36435f ///gauss, Magnetic field in Hsinchu
#define Gyro_gainx  0.002422966362920f///2000dps/2^15 = 61 miliDegree/s = 0.001065rad/s
#define Gyro_gainy  0.002422966362920f///0.001212716
#define Gyro_gainz  0.002422966362920f///0.0012375596
#define Acce_gainx  -0.002404245422390f///=8*9.81/2^15
#define Acce_gainy  -0.002344293490135f///=8*9.81/2^15
#define Acce_gainz  -0.002307390759185f///=8*9.81/2^15
#define Magn_gain   0.000244f ///8gauss/2^15 = 0.000244gauss
extern SPI sensor_LSM9D;
extern DigitalOut sensor_CSG;
extern DigitalOut sensor_CSXM;

extern unsigned char sensorG_CTRL_REG[6], sensorXM_CTRL_REG[9];

extern short int Gyro_axis_data[3], Gyro_axis_zero[3];
extern float Gyro_scale[3];

extern short int Acce_axis_data[3], Acce_axis_zero[3];
extern float Acce_scale[3];

extern short int Magn_axis_data[3], Magn_axis_zero[3];
extern float Magn_scale[3];

extern float B_x, B_y, B_z, B_total;
extern float u_cali[9], u_old[9];

extern bool setup_spi_sensor(void);

extern void init_Sensors(void);
extern void sensorG_setup(void);
extern void sensorXM_setup(void);
extern void sensorG_read_3axis(void);
extern void sensorX_read_3axis(void);
extern void sensorM_read_3axis(void);

extern short int filtered_sensor_data(unsigned char axis_index, float freq);
extern void reset_gyro_offset(void);
extern void reset_acceX_offset(void);

extern void get_9axis_scale(void);

extern unsigned char get_WhoAmI_G(void);
extern unsigned char get_WhoAmI_XM(void);

#endif // SPI_9DSENSOR_H_INCLUDED
