#include "mbed.h"

#define PWM_PERIOD          1.0f/244.0f
#define POWER_REDU_PW       0.0001f

#define PWR_REDU_PW         0.0001f  //100us ~ 200us
//#define PWR_REDU_DUTY_1024  PWR_REDU_PW*244*1024    //used by mega
//#define PWR_REDU_DUTY_256   PWR_REDU_PW*244*256     //used by mega
#define MIN_SERVO_PW        0.0007f  //pulse width in second
#define MAX_SERVO_PW        0.0023f  //pulse width in second
//#define MIN_SERVO_DUTY_1024 MIN_SERVO_PW*244*1024
//#define MAX_SERVO_DUTY_1024 MAX_SERVO_PW*244*1024
//#define MIN_SERVO_DUTY_256  MIN_SERVO_PW*244*256
//#define MAX_SERVO_DUTY_256  MAX_SERVO_PW*244*256

#define Ts 0.004098f
#define pi 3.14159f

#define H_PEDAL_DIVIDER 2
#define M_PEDAL_DIVIDER 3
#define L_PEDAL_DIVIDER 5
#define Z_PEDAL_DIVIDER 5//stop

#define TOT_ARM_POS     41
#define TOT_FOOT_POS    55  //48 + TOT_STOP_POS
#define TOT_STOP_POS  7
#define FIRST_POS  7

//#define HANDLE_STOP     10
//#define HANDLE_STRAIGHT 0
//#define HANDLE_START    10//16 - 6
//#define HANDLE_START_BAL  0//20
#define HANDLE_STOP     10
#define HANDLE_STRAIGHT 0 - 2
#define HANDLE_START    5  //16 - 6
#define HANDLE_START_BAL  0//20

#define COUN2_LOW_V   TOT_STOP_POS
#define COUN2_MID_V   19
#define COUN2_HIGH_V  38

#define COUN2_HANDLE_CNTRL  19
#define COUN2_HANDLE_START  10

extern PwmOut pwm_lw;
extern PwmOut pwm_le;
extern PwmOut pwm_ls;
extern PwmOut pwm_la;
extern PwmOut pwm_lk;
extern PwmOut pwm_ll;
extern PwmOut pwm_lb;
extern PwmOut pwm_rb;
extern PwmOut pwm_rl;
extern PwmOut pwm_rk;
extern PwmOut pwm_ra;
extern PwmOut pwm_rs;
extern PwmOut pwm_re;
extern PwmOut pwm_rw;
//extern PwmOut toe_servo;

extern const int servoangle_left[TOT_ARM_POS][3];
extern const int servoangle_right[TOT_ARM_POS][3];

extern const float footangle_left[TOT_FOOT_POS][4];
extern const float footangle_right[TOT_FOOT_POS][4];

extern void setupServo(void);

extern void pwm_left(float angle_up, float angle_mid, float angle_down);    //Left arm
extern void pwm_right(float angle_up, float angle_mid, float angle_down);   //Left arm
extern void lookuptable_steering(int8_t sensor_output);

extern void pwm_left_foot(float angle_1, float angle_2, float angle_3, float angle_4);
extern void pwm_right_foot(float angle_1, float angle_2, float angle_3, float angle_4);
extern void lookuptable_pedaling(int index);

extern void reset_left_butt(void);
extern void reset_pos(void);
extern void stop_pos(void);

extern int angle_to_duty(int resolution, float degree);
